/*************************************************/
/* Examples Program For "ET-dsPIC30F2010"  Board */
/* Hardware    : ET-dsPIC30F2010 TRAINING KIT V1 */
/* Target MCU  : dsPIC30F2010                    */
/*       	   : X-TAL : 7.3728 MHz              */
/*             : Run 117.9648MHz                 */
/*             : Selec OSC Mode = XT w/PLL 16x   */
/* Compiler    : MPLAB + C30 V1.33  		     */
/* Last Update : 1/October/2005                  */
/* Function    : Example Use SPI Connect 74HC595 */
/*             : 74HC595 Control Display 7Segment*/	
/*************************************************/
/* Used ET-MINI I/O 74HC595 Module Interface     */
/* DIN   = RF3(SPI-SDO1)                         */
/* LATCH = RB2(SPI-SS#1)                         */
/* CLOCK = RE8(SPI-SCK1)                         */
/*************************************************/

#include "p30f2010a2.h"	                               		// dsPIC30F2010 MPU Register
#include "spi.h"											// Used SPI Function Library

/* Setup Configuration For ET-dsPIC30F2010 */
_FOSC(CSW_FSCM_ON & XT_PLL16);								// Enable Clock Switching,Enable Fail-Salf Clock
                                                            // Closk Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_ON & BORV_45 & PWRT_64 & MCLR_EN);			// Enable Brown-Out = 4.5V,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-dsPIC30F2010 */

/* pototype  section */
void delay_led(unsigned long int);							// Delay Time Function
void init_spi(void);										// Initial SPI For Interface 74HC595

int main(void)
{  
  const char seg_code[10]={0x3F,0x06,0x5b,0x4F,0x66,  		// 7-Segment Code 0..9
                           0x6D,0x7D,0x27,0x7F,0x6F};	
  int  seg_pointer;

  TRISBbits.TRISB2 = 0;										// Config RB2 = Output
  init_spi();												// Initial SPI Function
   
  // Start Test Output SPI(74HC595) //
  while(1)													// Loop Continue
  {
    for(seg_pointer=0;seg_pointer<10;seg_pointer++)			// Loop Display 7-Segment = 0-9
    {      
      LATBbits.LATB2 = 0;									// Enable SPI Chips Select
      WriteSPI1(0xFF - seg_code[seg_pointer]);				// Send SPI to 74HC595 Output(Toggle Logic Drive)      
	  while(SPI1STATbits.SPITBF);							// Wait SPI Send Complete			
      LATBbits.LATB2 = 1;									// Disable SPI Chips Select
	
      delay_led(1500000);	    							// Display Delay	    			   	    
	} 	    
  }   							 
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}

/*************************************/
/* Initial dsPIC30F2010 SPI Function */
/* For Interface 74HC595(SPI Output) */
/*************************************/
void init_spi(void)
{
  CloseSPI1();												// Close SPI Before New Config
  
  // Initial SPI Interrupt Control
  ConfigIntSPI1(SPI_INT_DIS &								// Disable SPI Interrupt
                SPI_INT_PRI_7);								// Set Priority Interrupt = 7

  //***************************************************
  // ET-dsPIC30F2010 TRAINING KIT V1.0 Hardware Board
  // XTAL = 7.3728MHz
  // Fosc = 7.3728 MHz x 16 = 117.9648 MHz
  // Fcy  = Fosc / 4 
  //      = 117.9648 / 4 = 29.4912 MHz
  // Tcy  = 1 / 29.4912 MHz
  //      = 33.90842 nS
  //***************************************************
  // Open SPI Function (460.8KHz Baud)
  OpenSPI1(FRAME_ENABLE_OFF &								// Disable SPI Frame
           FRAME_SYNC_OUTPUT &								// SPI = Output
           ENABLE_SDO_PIN &									// SDO = Output Data to DIN of 74HC595
		   SPI_MODE16_OFF &									// SPI = Byte Mode(8 Bit Data)
           SPI_SMP_ON &										// Sampling Data on Half of Data Clock
		   SPI_CKE_ON &										// Change Data on Falling Edge Clock	
		   SLAVE_ENABLE_OFF &								// Disable SS# Pin Function
		   CLK_POL_ACTIVE_HIGH &							// Rising Edge Clock Active
		   MASTER_ENABLE_ON &								// SPI Function = Master
		   SEC_PRESCAL_4_1 &								// Secondary Prescale = 4:1
		   PRI_PRESCAL_16_1 ,								// Primary Prescale = 16:1
           
           SPI_ENABLE &										// Enable SPI Function
		   SPI_IDLE_STOP &									// Disable SPI in IDLE Mode
		   SPI_RX_OVFLOW_CLR);								// Clear Overflow Flag
}
